
#include "JabberMeetingAccountWapiSync.h"
#include "../MeetingServiceImpl.h"
#include "jcfcoreutils/StringUtils.h"

namespace CSFUnified
{

    static CSFLogger* jcfMeetingLogger = CSFLogger_getLogger("MeetingService-MeetingServiceImpl");

    JabberMeetingAccountWapiSync::JabberMeetingAccountWapiSync(IJabberMeetingAccountEvent * pEvent) : m_event(*pEvent)
    {
        CSFLogDebugS(jcfMeetingLogger, "JabberMeetingAccountWapiSync::JabberMeetingAccountWapiSync() begin")

        m_wapiHandle = 0;

        JWLoginMgr* pLoginMgr = JabberWerxCPP::CreateJabberWerxCPPSingleton()->jw_get_loginmgr();
        ((ILoginMgr*)pLoginMgr)->QueryInterface(__conuuidof(IWapiCli), (void**)&m_pWapiMgr);
        if (m_pWapiMgr != NULL)
        {
            m_iCookie = 0;
            AddRef();
            APAdvise(m_pWapiMgr, this, __conuuidof(IDefWapiEvent), &m_iCookie);
        }

        if (NULL == m_pWapiMgr)
        {
            CSFLogErrorS(jcfMeetingLogger, "JabberMeetingAccountWapiSync::JabberMeetingAccountWapiSync() get m_pWapiMgr failed.")
        }
        else
        {
            CSFLogInfoS(jcfMeetingLogger, "JabberMeetingAccountWapiSync::JabberMeetingAccountWapiSync() get m_pWapiMgr success.")
        }
    }
    
    JabberMeetingAccountWapiSync::~JabberMeetingAccountWapiSync()
    {
        CSFLogDebugS(jcfMeetingLogger, "JabberMeetingAccountWapiSync::~JabberMeetingAccountWapiSync() begin")

        if (NULL != m_pWapiMgr)
        {
            APUnAdvise(m_pWapiMgr, __conuuidof(IWapiCli), m_iCookie);
        }

        m_pWapiMgr = NULL;
        m_iCookie = 0;
        m_wapiHandle = 0;

        CSFLogDebugS(jcfMeetingLogger, "JabberMeetingAccountWapiSync::~JabberMeetingAccountWapiSync() end")
    }
    
    void JabberMeetingAccountWapiSync::start()
    {
        CSFLogDebugS(jcfMeetingLogger, "JabberMeetingAccountWapiSync::start()");
    }
    
    void JabberMeetingAccountWapiSync::stop()
    {
        CSFLogDebugS(jcfMeetingLogger, "JabberMeetingAccountWapiSync::stop()");
        
        if (m_wapiHandle != 0 && NULL != m_pWapiMgr)
        {
            m_pWapiMgr->CancelRequest(m_wapiHandle);
            m_wapiHandle = 0;
            CSFLogDebugS(jcfMeetingLogger, "JabberMeetingAccountWapiSync::cancelRequest()");
        }
    }
    
    void JabberMeetingAccountWapiSync::syncAllSite()
    {
        CSFLogDebugS(jcfMeetingLogger, "JabberMeetingAccountWapiSync::syncAllSite()");
        
        if (NULL != m_pWapiMgr)
        {
            m_pWapiMgr->GetWbxAccountsAssocAsync(this, &m_wapiHandle);
            CSFLogInfoS(jcfMeetingLogger, "JabberMeetingAccountWapiSync::GetWbxAccountsAssocAsync()");
        }
    }
    
    void JabberMeetingAccountWapiSync::getDefaultSite()
    {
        if (NULL != m_pWapiMgr)
        {
            m_pWapiMgr->GetDefWbxAccountAsync(this, &m_wapiHandle);
            CSFLogDebugS(jcfMeetingLogger, "JabberMeetingAccountWapiSync::GetDefWbxAccountAsync()");
        }
    }
    
    void JabberMeetingAccountWapiSync::setDefaultSite(SMART_PTR_NS::shared_ptr<MeetingSiteImpl> site, std::string sessionTicket, long keepAliveTime)
    {
        if (NULL != m_pWapiMgr)
        {
            m_pWapiMgr->SetDefWbxAccountAsync(site->getSiteUrl(), site->getUserName(), site->getPassword(), this, &m_wapiHandle);
            CSFLogDebugS(jcfMeetingLogger, "JabberMeetingAccountWapiSync::setDefaultSite() siteURL = " << site->getSiteUrl().c_str());
        }
    }
    
    void JabberMeetingAccountWapiSync::deleteSite(std::string siteUrl)
    {
        if (NULL != m_pWapiMgr)
        {
            m_pWapiMgr->DelWbxAccountAssocAsync(siteUrl, this, &m_wapiHandle);
            CSFLogDebugS(jcfMeetingLogger, "JabberMeetingAccountWapiSync::deleteSite() siteURL = " << siteUrl.c_str());
        }
    }
    
    stdapi JabberMeetingAccountWapiSync::OnSink(AT::CTString const& xmlResponse, WapiCallType nReqType, WAPIMESSAGE& wmsg, AT::CTString const& strUserData)
    {
        CSFLogDebugS(jcfMeetingLogger, "JabberMeetingAccountWapiSync::OnSink() WapiCallType nReqType = " << nReqType);

        m_wapiHandle = 0;
        if (WCT_GET_WBX_ACCOUNTS_ASSOC == nReqType)
        {
            onGetAllAccounts(xmlResponse);
        }
        else if (WCT_GET_DEF_WBX_ACCOUNT_ASSOC == nReqType)
        {
            onDefaultAccount(xmlResponse, true);
        }
        else if (WCT_SET_DEF_WBX_ACCOUNT_ASSOC == nReqType)
        {
            onDefaultAccount(xmlResponse, false);
        }

        return CON_S_OK;
    }
    

    void JabberMeetingAccountWapiSync::onGetAllAccounts(AT::CTString xmlRespond)
    {
        CSFLogDebugS(jcfMeetingLogger, "JabberMeetingAccountWapiSync::onGetAllAccounts()" << xmlRespond.c_str());
        
        int i = 0;
        std::list<SMART_PTR_NS::shared_ptr<MeetingSiteImpl> > siteList;
        CGetWbxAccountsResp resp;
        WAPIMESSAGE wapiMsg;
        resp.ParseXML(xmlRespond);
        wapiMsg.SetErrorMsg(xmlRespond, resp.strReason, resp.strExceptionID);
        
        if (resp.IsSuccess())
        {
            for (i = 0; i < resp.m_vtOrgSite.size(); i++)
            {
                SMART_PTR_NS::shared_ptr<MeetingSiteImpl> site;
                if (parseMeetingSite(site, resp.m_vtOrgSite[i]))
                {
					addSite2List(site, siteList);
                }
            }
            
            for (i = 0; i < resp.m_vtUisSite.size(); i++)
            {
                SMART_PTR_NS::shared_ptr<MeetingSiteImpl> site;
                if (parseMeetingSite(site, resp.m_vtUisSite[i]))
                {
					addSite2List(site, siteList);
				}
            }
        }
        
        m_event.onGetAllSite(resp.IsSuccess(), siteList);
    }
    
    void JabberMeetingAccountWapiSync::onDefaultAccount(AT::CTString xmlRespond, bool isGetDefault)
    {
        CSFLogDebugS(jcfMeetingLogger, "JabberMeetingAccountWapiSync::onDefaultAccount()" << xmlRespond.c_str());
        
        std::string sessionTicket = "";
        long keepAliveTime = 0;
        SMART_PTR_NS::shared_ptr<MeetingSiteImpl> site;

        WAPIMESSAGE msg;
        CGrantSessionResp resp;
        resp.ParseXML(xmlRespond);
        msg.SetErrorMsg(xmlRespond, resp.strReason, resp.strExceptionID);

        if (resp.IsSuccess())
        {
            site.reset(new MeetingSiteImpl());
            site->setSiteUrl(resp.m_strSite.c_str());
            site->setUserName(resp.m_strUser.c_str());
            
            if (resp.m_strPass.length() > 0)
            {
                std::string strTempPwd = "";
                decodeWapiPassword(resp.m_strPass, strTempPwd);
                csf::SecureString securePass(strTempPwd);
                site->setPassword(securePass);
                site->setSSOFlag(0);
                csf::SecureStringUtils::CSFZeroString(strTempPwd);
            }
            else
            {
                site->setSSOFlag(1);
                sessionTicket = resp.m_strSessionTicket.c_str();
                keepAliveTime = JCFCoreUtils::toUnsignedInt(resp.m_strSessionTicket.c_str(), 0);
            }
            
            if (isGetDefault)
            {
                m_event.onGetDefaultSite(e_jmaec_success, "", site, sessionTicket, keepAliveTime);
            }
            else
            {
				m_event.onSetDefaultSite(e_jmaec_success, "", site, sessionTicket, keepAliveTime);
            }
        }
        else
        {
            JABBER_MEETING_ACCOUNT_ERROR_CODE eErrorCode;
			std::string errorMsg = "";
			if (0 == resp.strExceptionID.CompareNoCase("wapi.expired_credential"))
            {
                CSFLogDebugS(jcfMeetingLogger, "Entry JabberMeetingAccountWapiSync::onDefaultAccount --- RETRY = TRUE.");
                //////////////////m_bRetry = true;
            }
            
            if(!msg.IsSuccess())
            {
                if (msg.dwerror == 12002)	//handle http call time out
                {
                    eErrorCode = e_jmaec_error_timeout;
                }
                else if (msg.dwerror >= 12001 && msg.dwerror <= 12156)
                {
                    eErrorCode = e_jmaec_error_network;
                }
                else
                {
					if (xmlRespond.length() == 0)
					{
						eErrorCode = e_jmaec_error_site_url_Invalid;
					}
					else
					{
						eErrorCode = e_jmaec_error_ref_string;
						std::string strReason = resp.strReason;
						eErrorCode = getErrorCode(msg.strReason, strReason);
						errorMsg = strReason;
					}
				}
            }
            else if(!resp.IsSuccess())
            {
				if (xmlRespond.length() == 0)
				{
					eErrorCode = e_jmaec_error_site_url_Invalid;
				}
				else
				{
					eErrorCode = e_jmaec_error_ref_string;
					std::string strReason = resp.strReason;
					eErrorCode = getErrorCode(msg.strReason, strReason);
					errorMsg = strReason;
				}
            }
            
            if (isGetDefault)
            {
				m_event.onGetDefaultSite(eErrorCode, errorMsg, site, "", 0);
            }
            else
            {
				m_event.onSetDefaultSite(eErrorCode, errorMsg, site, "", 0);
            }
        }
    }
    
    bool JabberMeetingAccountWapiSync::parseMeetingSite(SMART_PTR_NS::shared_ptr<MeetingSiteImpl>& site, WbxSiteInfo& info)
    {
        if (info.strSite.length() == 0)
        {
            CSFLogDebugS(jcfMeetingLogger, "JabberMeetingAccountWapiSync::onGetAllAccounts()  site url is empty");
            return false;
        }
        
        bool isEditable = false;
        bool isDeletable = false;
        if (!checkSiteProperty(info.iSiteType, isEditable, isDeletable))
        {
            CSFLogDebugS(jcfMeetingLogger, "JabberMeetingAccountWapiSync::onGetAllAccounts()  site type is invisible SiteType = " << info.iSiteType);
            return false;
        }
        
        site.reset(new MeetingSiteImpl());
        site->setSiteUrl(info.strSite.c_str());
        site->setSiteDescription(info.strDescription.c_str());
        //site->setUserName("");
        //site->setPassword("");
        site->setEditableFlag(isEditable);
        site->setDeletableFlag(isDeletable);
        site->setDefaultSiteFlag(false);
        site->setActiveFlag(false);
        site->setSiteFlag(0);
		site->setSSOFlag(isEditable ? 0 : 1);
        return true;
    }
    
    bool JabberMeetingAccountWapiSync::checkSiteProperty(int siteType, bool& isEditable, bool& isDeletable)
    {
        enum E_WAPI_SITE_TYPE_DEF
        {
            e_ewst_no_site_type = 0,
            e_ewst_invisible_org_mapped,
            e_ewst_visible_org_mapped,
            e_ewst_invisible_org_linked,
            e_ewst_visible_org_linked,
            e_ewst_visible_org_linked_user_define,
            e_ewst_user_define,
            e_ewst_invisible_org_linked_user_define,
            e_ewst_invisible_org_mapped_user_define
        };
        
        bool isVisible = true;
        switch (siteType)
        {
            case e_ewst_visible_org_mapped:
                isEditable = false;
                isDeletable = false;
                break;

            case e_ewst_visible_org_linked:
            case e_ewst_visible_org_linked_user_define:
                isEditable = true;
                isDeletable = false;
                break;
                
            case e_ewst_user_define:
			case e_ewst_no_site_type:
                isEditable = true;
                isDeletable = true;
                break;
                
            case e_ewst_invisible_org_mapped:
            case e_ewst_invisible_org_linked:
            case e_ewst_invisible_org_linked_user_define:
            case e_ewst_invisible_org_mapped_user_define:
            default:
                isVisible = false;
                break;
        }
        
        return isVisible;
    }
    
    JABBER_MEETING_ACCOUNT_ERROR_CODE JabberMeetingAccountWapiSync::getErrorCode(std::string &errMsg, std::string &strReason)
    {
        std::string err;
        std::string prefix;
        err = errMsg;
        const std::string wapi = "wapi.";
        const std::string interval = " - ";
        size_t found = err.find(wapi);
        if(found != std::string::npos)
        {
            found = err.find(interval);
            if(found != std::string::npos)
            {
                prefix = err.substr(0, found);
                strReason = err.substr(found + interval.size());
            }
        }
        else
        {
            strReason = err;
        }
        
        JABBER_MEETING_ACCOUNT_ERROR_CODE eErrorCode;
        if(prefix == "wapi.centersiteurl_invalid")
        {
            eErrorCode = e_jmaec_error_site_url_Invalid;
        }
        else if(prefix == "wapi.centeraccount_not_found")
        {
            eErrorCode = e_jmaec_error_account_not_found;
        }
        else if(prefix == "wapi.centeraccount_pwdinvalid")
        {
            eErrorCode = e_jmaec_error_account_password_invalid;
        }
        else if(prefix == "wapi.center_login_required")
        {
            eErrorCode = e_jmaec_error_login_required;
        }
        else if(prefix == "wapi.no_user_account")
        {
            eErrorCode = e_jmaec_error_account_no_user;
        }
        else if(prefix == "wapi.user_inactive")
        {
            eErrorCode = e_jmaec_error_account_user_inactive;
        }
        else if(prefix == "wapi.login_failed")
        {
            eErrorCode = e_jmaec_error_account_login_failed;
        }
        else if(prefix == "wapi.center_account_deactivated")
        {
            eErrorCode = e_jmaec_error_account_deactivated;
        }
        else if(prefix == "wapi.verifyssocentersite_failed")
        {
            eErrorCode = e_jmaec_error_account_verify_sso_centersite_failed;
        }
        else if(prefix == "wapi.notuserconfigured_association_delete_failed")
        {
            eErrorCode = e_jmaec_error_account_association_delete_failed;
        }
        else if(prefix == "wapi.login_failed_account_has_been_locked")
        {
            eErrorCode = e_jmaec_error_account_has_been_locked;
        }
        else if(prefix == "wapi.login_failed_password_has_expired")
        {
            eErrorCode = e_jmaec_error_account_password_has_expired;
        }else if(prefix == "wapi.centersite_unavailable")
        {
            eErrorCode = e_jmaec_error_account_unavailable;
        }
        else if(prefix == "wapi.centeraccount_locked")
        {
            eErrorCode = e_jmaec_error_account_locked;
        }
        else if(prefix == "wapi.centeraccount_creation_failed")
        {
            eErrorCode = e_jmaec_error_account_creation_failed;
        }else if(prefix == "wapi.centeraccount_creation_not_allowed")
        {
            eErrorCode = e_jmaec_error_account_creation_not_allowed;
        }
        else if(prefix == "wapi.centeraccount_passwdforcechg")
        {
            eErrorCode = e_jmaec_error_account_password_force_change;
        }
        else if(prefix == "wapi.centeraccount_passwdreset")
        {
            eErrorCode = e_jmaec_error_account_password_reset;
        }
        else if(prefix == "wapi.centeraccount_passwdtmpexp")
        {
            eErrorCode = e_jmaec_error_account_password_tmp_exp;
        }
        else if(prefix == "wapi.center_siteurl_not_found")
        {
            eErrorCode = e_jmaec_error_account_site_url_not_found;
        }
        else if(prefix == "wapi.center_sso_not_allowed")
        {
            eErrorCode = e_jmaec_error_account_sso_not_allowed;
        }
        else if(prefix == "wapi.centersiterelease_not_support")
        {
            eErrorCode = e_jmaec_error_account_site_release_not_support;
        }
        else if(prefix == "wapi.getsessionticket_failed")
        {
            eErrorCode = e_jmaec_error_account_password_invalid;
        }
        else if(prefix == "wapi.donot_support_attendeerole")
        {
            eErrorCode = e_jmaec_error_donot_support_attendeerole;
        }
        
        CSFLogDebugS(jcfMeetingLogger, "WapiMeetingAccountManagerImpl::getErrorCode() errMsg = " << errMsg.c_str() << " strReason = " << strReason.c_str() << " eErrorCode = " << (int)eErrorCode);
        
        return eErrorCode;
    }
    
    void JabberMeetingAccountWapiSync::decodeWapiPassword(std::string strInput, std::string& strOutput)
    {        
        const std::string SSO_AES_KEY = "83d258caa9b9f98f0a6c8a3766f32d2e";
        const std::string SSO_AES_VI = "11070b131705030d2b251f2f35211d29";
        strInput += "\n";
        
        AT::CTString ctsrInput = strInput;
        AT::CTString ctsrOut = "";
        Aes128Cbc(ctsrInput, SSO_AES_KEY, SSO_AES_VI, ctsrOut, FALSE);
        
        strOutput = ctsrOut;
    }

	void JabberMeetingAccountWapiSync::addSite2List(SMART_PTR_NS::shared_ptr<MeetingSiteImpl>& site, std::list<SMART_PTR_NS::shared_ptr<MeetingSiteImpl> >& siteList)
	{
		std::list<SMART_PTR_NS::shared_ptr<MeetingSiteImpl> >::iterator it = siteList.begin();
		while (it != siteList.end())
		{
			if ((*it)->getSiteUrl() == site->getSiteUrl())
			{
				return;
			}

			it++;
		}

		siteList.push_back(site);
	}
}
